#!/usr/bin/env python
# -*- coding: utf-8 -*-
from utils import *

pfiles = {}
pfiles['_meta'] = {
    'IDX':0,
    'TYPE':'html',
    'CAPTION':u'METAタグ',
}
pfiles['_header'] = {
    'IDX':1,
    'TYPE':'html',
    'CAPTION':u'ページ ヘッダー',
}
pfiles['_footer'] = {
    'IDX':2,
    'TYPE':'html',
    'CAPTION':u'ページ フッター',
}
pfiles['_menu'] = {
    'IDX':3,
    'TYPE':'html',
    'CAPTION':u'GLOBAL NAVI MENU HTML',
}
pfiles['_design'] = {
    'IDX':5,
    'TYPE':'css',
    'CAPTION':u'サイトデザイン css',
}
pfiles['_paper'] = {
    'IDX':6,
    'TYPE':'css',
    'CAPTION':u'PANEO MEDIA Query Paper css',
}
pfiles['_smartphone'] = {
    'IDX':7,
    'TYPE':'css',
    'CAPTION':u'スマートフォン用 css',
}
pfiles['_tumblr'] = {
    'IDX':8,
    'TYPE':'html',
    'CAPTION':u'Tumblr Template',
}
pfiles['_aws_item'] = {
    'IDX':9,
    'TYPE':'html',
    'CAPTION':u'Amazon aws item Template',
}
pfiles['_aws_search'] = {
    'IDX':10,
    'TYPE':'html',
    'CAPTION':u'Amazon aws search Template',
}

class View:

    def __init__(self):
        self.cms = 'files'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self ):

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        dic.close()



        return render.pfiles( 
                                cms = self.cms,                        
                                scfg = scfg, 
                                pfiles = pfiles,
                                mode = 'view',
                                id = None,
                                html_file = None,
        )

    def POST( self, id=None ):

        i = web.input()

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        dic.close()
        
        shutil.copyfile(PANEO_SITE_DATA_DIR+id+'.html', PANEO_SITE_DATA_DIR+id+'.html.bak')
        file = codecs.open(PANEO_SITE_DATA_DIR+id+'.html',"w","utf8")
        file.write(i.HTMLTEMPLATE)
        file.close()

        return self.GET( id )

class Edit:

    def __init__(self):
        self.cms = 'files'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self, id=None ):

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        dic.close()

        try:
            file = codecs.open(PANEO_SITE_DATA_DIR+id+"."+pfiles[id].get('TYPE'),"r","utf8")
            html_file=file.read()
            file.close()
        except:
            pass

        return render.pfiles(  
                                cms = self.cms,                        
                                mode = 'edit',
                                id = id,
                                scfg = scfg, 
                                pfiles = pfiles,
                                html_file = html_file,
        )

    def POST( self, id=None ):

        i = web.input()

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        dic.close()

        #TEMPLATEのバックアップ
        if os.path.exists(PANEO_SITE_DATA_DIR+id+'.'+pfiles[id].get("TYPE")):
            shutil.copyfile(PANEO_SITE_DATA_DIR+id+'.'+pfiles[id].get("TYPE"),PANEO_SITE_DATA_DIR+'backup/'+id+'.'+pfiles[id].get("TYPE")+'.'+dt+'.bak')

        file = codecs.open(PANEO_SITE_DATA_DIR+id+'.'+pfiles[id].get("TYPE"),"w","utf8")
        file.write(i.HTML)
        file.close()

        return self.GET( id )


